/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.content.trains.RailwaySavedData;
import com.zurrtum.create.content.trains.display.GlobalTrainDisplayData;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackGraphSync;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.signal.EdgeGroupColor;
import com.zurrtum.create.content.trains.signal.SignalEdgeGroup;
import com.zurrtum.create.infrastructure.packet.s2c.AddTrainPacket;
import com.zurrtum.create.infrastructure.packet.s2c.RemoveTrainPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GlobalRailwayManager {
    public Map<UUID, TrackGraph> trackNetworks;
    public Map<UUID, SignalEdgeGroup> signalEdgeGroups;
    public Map<UUID, Train> trains;
    public TrackGraphSync sync;
    private List<Train> movingTrains;
    private List<Train> waitingTrains;
    private RailwaySavedData savedData;
    public int version;

    public GlobalRailwayManager() {
        this.cleanUp();
    }

    public void playerLogin(MinecraftServer server, class_3222 player) {
        this.loadTrackData(server);
        for (TrackGraph g : this.trackNetworks.values()) {
            this.sync.sendFullGraphTo(g, player);
        }
        ArrayList<UUID> ids = new ArrayList<UUID>(this.signalEdgeGroups.size());
        ArrayList<EdgeGroupColor> colors = new ArrayList<EdgeGroupColor>(this.signalEdgeGroups.size());
        for (SignalEdgeGroup group : this.signalEdgeGroups.values()) {
            ids.add(group.id);
            colors.add(group.color);
        }
        this.sync.sendEdgeGroups(ids, colors, player);
        for (Train train : this.trains.values()) {
            player.field_13987.method_14364((class_2596)new AddTrainPacket(train));
        }
    }

    public void levelLoaded(MinecraftServer server) {
        this.cleanUp();
        this.savedData = null;
        this.loadTrackData(server);
    }

    private void loadTrackData(MinecraftServer server) {
        if (this.savedData != null) {
            return;
        }
        this.savedData = RailwaySavedData.load(server);
        this.trains = this.savedData.getTrains();
        this.trackNetworks = this.savedData.getTrackNetworks();
        this.signalEdgeGroups = this.savedData.getSignalBlocks();
        this.movingTrains.addAll(this.trains.values());
    }

    public void cleanUp() {
        this.trackNetworks = new HashMap<UUID, TrackGraph>();
        this.signalEdgeGroups = new HashMap<UUID, SignalEdgeGroup>();
        this.trains = new HashMap<UUID, Train>();
        this.sync = new TrackGraphSync();
        this.movingTrains = new LinkedList<Train>();
        this.waitingTrains = new LinkedList<Train>();
        GlobalTrainDisplayData.statusByDestination.clear();
    }

    public void markTracksDirty() {
        if (this.savedData != null) {
            this.savedData.method_80();
        }
    }

    public void addTrain(Train train) {
        this.trains.put(train.id, train);
        this.movingTrains.add(train);
    }

    public void removeTrain(UUID id) {
        Train removed = this.trains.remove(id);
        if (removed == null) {
            return;
        }
        this.movingTrains.remove(removed);
        this.waitingTrains.remove(removed);
    }

    public TrackGraph getOrCreateGraph(UUID graphID, int netId) {
        return this.trackNetworks.computeIfAbsent(graphID, uid -> {
            TrackGraph trackGraph = new TrackGraph(graphID);
            trackGraph.setNetId(netId);
            return trackGraph;
        });
    }

    public void putGraphWithDefaultGroup(MinecraftServer server, TrackGraph graph) {
        SignalEdgeGroup group = new SignalEdgeGroup(graph.id);
        this.signalEdgeGroups.put(graph.id, group.asFallback());
        this.sync.edgeGroupCreated(server, graph.id, group.color);
        this.putGraph(graph);
    }

    public void putGraph(TrackGraph graph) {
        this.trackNetworks.put(graph.id, graph);
        this.markTracksDirty();
    }

    public void removeGraphAndGroup(MinecraftServer server, TrackGraph graph) {
        this.signalEdgeGroups.remove(graph.id);
        this.sync.edgeGroupRemoved(server, graph.id);
        this.removeGraph(graph);
    }

    public void removeGraph(TrackGraph graph) {
        this.trackNetworks.remove(graph.id);
        this.markTracksDirty();
    }

    public void updateSplitGraph(class_1936 level, TrackGraph graph) {
        Set<TrackGraph> disconnected = graph.findDisconnectedGraphs(level, null);
        MinecraftServer server = level.method_8503();
        for (TrackGraph d : disconnected) {
            this.putGraphWithDefaultGroup(server, d);
        }
        if (!disconnected.isEmpty()) {
            this.sync.graphSplit(graph, disconnected);
            this.markTracksDirty();
        }
    }

    @Nullable
    public TrackGraph getGraph(TrackNodeLocation vertex) {
        if (this.trackNetworks == null) {
            return null;
        }
        for (TrackGraph railGraph : this.trackNetworks.values()) {
            if (railGraph.locateNode(vertex) == null) continue;
            return railGraph;
        }
        return null;
    }

    public List<TrackGraph> getGraphs(TrackNodeLocation vertex) {
        if (this.trackNetworks == null) {
            return Collections.emptyList();
        }
        ArrayList<TrackGraph> intersecting = new ArrayList<TrackGraph>();
        for (TrackGraph railGraph : this.trackNetworks.values()) {
            if (railGraph.locateNode(vertex) == null) continue;
            intersecting.add(railGraph);
        }
        return intersecting;
    }

    public void tick(class_3218 level) {
        if (level.method_27983() != class_1937.field_25179) {
            return;
        }
        for (SignalEdgeGroup group : this.signalEdgeGroups.values()) {
            group.trains.clear();
            group.reserved = null;
        }
        MinecraftServer server = level.method_8503();
        for (TrackGraph graph : this.trackNetworks.values()) {
            graph.tickPoints(server, true);
            graph.resolveIntersectingEdgeGroups((class_1937)level);
        }
        this.tickTrains((class_1937)level);
        for (TrackGraph graph : this.trackNetworks.values()) {
            graph.tickPoints(server, false);
        }
        boolean bl = GlobalTrainDisplayData.updateTick = level.method_75260() % 100L == 0L;
        if (GlobalTrainDisplayData.updateTick) {
            GlobalTrainDisplayData.refresh();
        }
    }

    private void tickTrains(class_1937 level) {
        Train train;
        for (Train train2 : this.waitingTrains) {
            train2.earlyTick(level);
        }
        for (Train train2 : this.movingTrains) {
            train2.earlyTick(level);
        }
        for (Train train2 : this.waitingTrains) {
            train2.tick(level);
        }
        for (Train train2 : this.movingTrains) {
            train2.tick(level);
        }
        class_3324 playerManager = level.method_8503().method_3760();
        Iterator<Train> iterator = this.waitingTrains.iterator();
        while (iterator.hasNext()) {
            train = iterator.next();
            if (train.invalid) {
                iterator.remove();
                this.trains.remove(train.id);
                playerManager.method_14581((class_2596)new RemoveTrainPacket(train));
                continue;
            }
            if (train.navigation.waitingForSignal != null) continue;
            this.movingTrains.add(train);
            iterator.remove();
        }
        iterator = this.movingTrains.iterator();
        while (iterator.hasNext()) {
            train = iterator.next();
            if (train.invalid) {
                iterator.remove();
                this.trains.remove(train.id);
                playerManager.method_14581((class_2596)new RemoveTrainPacket(train));
                continue;
            }
            if (train.navigation.waitingForSignal == null) continue;
            this.waitingTrains.add(train);
            iterator.remove();
        }
    }

    public GlobalRailwayManager sided(class_1936 level) {
        if (level != null && !level.method_8608()) {
            return this;
        }
        return AllClientHandle.INSTANCE.getGlobalRailwayManager();
    }
}

